<?php
	include_once('config/database.php');
	include_once('objects/datacontext.php');	

	// instantiate database and PDO connection
	$database = new Database();
	$db = $database->getConnection();

	$context = new DataContext($db, basename(__FILE__, '.php'));
	$site = $context->get_site();

	$flag = true;
	$active_class = "";
	$sno = 0;
?>

<!doctype html>
<html lang="en">
<head>
	<!-- meta tags and title goes here -->
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<meta charset="UTF-8">
	<title><?php echo $site->title; ?></title>
	<meta name="description" content="">
	<meta name="author" content="">
	<!-- Mobile Specific Metas here -->
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, shrink-to-fit=no">
	<!-- CSS & google font link goes here -->
	<link rel="stylesheet" type="text/css" href="dist/css/bootstrap.min.css" media="all">
	<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700|Varela+Round" rel="stylesheet">
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
	
	<!-- custom css added -->
	<link rel="stylesheet" type="text/css" href="style-<?php echo $site->color_scheme; ?>.css" media="all">
	<link rel="stylesheet" type="text/css" href="dist/css/custom.css" media="all">
	<link rel="stylesheet" type="text/css" href="dist/css/responsive.css" media="all">
	<!-- Favicons goes here -->
	<link rel="shortcut icon" href="images/favicon.ico">
	<!-- js plugins goes here -->
	<script src="dist/js/modernizr.js"></script>
	<!--[if lt IE 9]>
		<script src="dist/js/html5shiv.js"></script>
	<![endif]-->
	<!-- <script defer src="https://use.fontawesome.com/releases/v5.0.8/js/all.js"></script> -->
</head>

<body>
	<!-- Page structure start 
	================================================== -->
	<div class="wrapper">
		<header class="header clearfix">
			<nav class="navbar navbar-default" role="navigation">
				<div class="container">
					<!-- Brand and toggle get grouped for better mobile display -->
					<div class="navbar-header">
						<button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-ex1-collapse">
							<span class="sr-only">Toggle navigation</span>
							<span class="icon-bar"></span>
							<span class="icon-bar"></span>
							<span class="icon-bar"></span>
						</button>
						<h1 class="logo clearfix">
							<a class="navbar-brand" href="/">
								<?php if ($site->logo_image != NULL) : ?>
								<img src="<?php echo $site->logo_image; ?>" alt="<?php echo $site->logo; ?>" />
								<?php else : ?>
								<?php echo $site->logo; ?>
								<?php endif; ?>
							</a>
						</h1>
					</div>
			
					<!-- Collect the nav links, forms, and other content for toggling -->
					<div class="collapse navbar-collapse navbar-ex1-collapse">
						<ul class="nav navbar-nav navbar-right js-site-menu">
							<?php foreach($site->menu as $menu) : $active_class = $flag ? "active" : ""; $flag = false; ?>
								<?php if ($menu->sub_menu) :?>
									<li class="dropdown <?php echo $active_class; ?>">
										<a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button"><?php echo $menu->label; ?> <span class="caret"></span></a>
										<ul class="dropdown-menu">
											<?php foreach($menu->sub_menu as $submenu) :?>
												<li><a href="<?php echo $submenu->link; ?>"><?php echo $submenu->label; ?></a></li>
											<?php endforeach; ?>
										</ul>
									</li>
								<?php else : ?>
									<li class="<?php echo $active_class; ?>"><a href="<?php echo $menu->link; ?>"><?php echo $menu->label; ?></a>
								<?php endif; ?>
							<?php endforeach; ?>
						</ul>
					</div><!-- /.navbar-collapse -->
				</div>
			</nav>
		</header>
		<?php if ($site->images) : $flag = true; ?>
		<section class="banner-wrap">
			<div id="carousel-id" class="carousel slide" data-ride="carousel">
				<ol class="carousel-indicators">
					<?php foreach ($site->images as $image) : $active_class = $flag ? "active" : ""; $flag = false; ?>
					<li data-target="#carousel-id" data-slide-to="<?php echo $sno; ?>" class="<?php echo $active_class; ?>"></li>
					<?php $sno++; ?>
					<?php endforeach; ?>
				</ol>
				<div class="carousel-inner">
					<?php $flag = true; ?>
					<?php foreach ($site->images as $image) : $active_class = $flag ? "active" : ""; $flag = false; ?>
					<div class="item <?php echo $active_class; ?>">
						<img class="img-responsive" src="<?php echo $image ?>" alt="">
					</div>
					<?php $sno++; ?>
					<?php endforeach; ?>
				</div>
				<a class="left carousel-control" href="#carousel-id" data-slide="prev"><span class="glyphicon glyphicon-chevron-left"></span></a>
				<a class="right carousel-control" href="#carousel-id" data-slide="next"><span class="glyphicon glyphicon-chevron-right"></span></a>
			</div>
		</section> <!-- /banner-wrap end -->
		<?php endif; ?>
		<section class="content-wrap clearfix">
			<div class="container">
				<div class="title pad" id="about">
					<h2>About Us</h2>
					<?php echo $site->content_html; ?>
				</div>

				<div class="title" id="services">
					<h2>Services</h2>
					<?php foreach ($site->services as $service) : ?>
					<div class="panel panel-default">
						<div class="panel-heading"><?php echo $service[0]->service_name; ?></div>
						<div class="panel-body">
							<?php foreach ($service as $s) : ?>
							<?php if ($s->service_text_type == "bullet") : $arr_service_list = explode('~', $s->service_text); ?>
							<ul class="list-group">
							<?php foreach ($arr_service_list as $item) : ?>
								<li class="list-group-item"><i class="fa fa-check-square-o"></i><?php echo $item; ?></li>
							<?php endforeach; ?>
							</ul>
							<?php else : ?>
							<p><?php echo $s->service_text ?></p>
							<?php endif; ?>
							<?php endforeach; ?>
						</div>
					</div>
					<?php endforeach; ?>
				</div>
			</div>

			<div class="title" id="contact">
				<h2>Contact Us</h2>
				<address> 								
					<span><i class="fa fa-envelope"></i> <?php echo $site->address; ?></span><br />						
					<span><i class="fa fa-phone"></i> <?php echo $site->phone; ?></span> 							
				</address>
			</div>
		</section> <!-- /content-wrap end -->
		<div id="map_canvas">
			<iframe src="https://www.google.com/maps?q=<?php echo $site->address; ?>&output=embed" width="100%" height="450" frameborder="0" style="border:0" allowfullscreen></iframe>
		</div>
		<footer class="footer clearfix">			
			<div class="footer-holder clearfix">
				<div class="container">
					<div class="row">
						<div class="col-sm-12 infos widget">
							<h4><span>Service Areas</span></h4>
							<?php $serviceAreas = implode(',', $site->service_areas); ?>
							<p><?php echo $serviceAreas; ?></p>

							<small>copyright © 2018</small>
						</div>
					</div>
				</div>
			</div>
		</footer>
	</div> <!-- /.wrapper end -->
	<!-- Page structure end 
	================================================== -->
	<!-- core JavaScript
	================================================== -->
	<!-- Placed at the end of the document so the pages load faster -->
	<script src="dist/js/jquery.js"></script>
	<script src="dist/js/bootstrap.min.js"></script>
	<script src="dist/js/smoothscroll.js"></script>
	<script src="dist/js/custom.js"></script>
</body>
</html>