<?php
/**
* DataContext class
*/

include_once('site.php');
class DataContext
{

	//database connection and table name
	private $conn;
	private $site_id;
	
	function __construct($db, $siteid)
	{
		$this->conn = $db;
		$this->site_id = $siteid;
	}

	function get_site() {
		$site = new Site();
		$site->site_id = $this->site_id;

		$query = "SELECT site_id, logo, title, address, phone, color_scheme, content_html, footer_html, PageTitlePrefix FROM site WHERE site_id = :siteid;";

		$stmt = $this->conn->prepare($query);
		$stmt->execute([':siteid' => $this->site_id]);
		if ($stmt->rowCount() <= 0) {
			return null;
		}

		$row = $stmt->fetch(PDO::FETCH_ASSOC);
		extract($row);
		$site->logo = $logo;
		$site->title = $title;
		$site->address = $address;
		$site->phone = $phone;
		$site->color_scheme = $color_scheme;
		$site->content_html = $content_html;
		$site->footer_html = $footer_html;
		$site->page_title_prefix = $PageTitlePrefix;

		//logo img
		$query = "SELECT LogoUrl from tbl_logo where SiteID = :siteid;";
		$stmt = null;
		$stmt = $this->conn->prepare($query);
		$stmt->execute([':siteid' => $this->site_id]);
		if ($stmt->rowCount() > 0) {
			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			extract($row);
			$site->logo_image = $LogoUrl;
		}

		//site menu
		$query = "SELECT menu_id, parent_menu_id, Coalesce(tbl_pagetitle.PageTitle, label) label, link 
					FROM site_menu 
						LEFT JOIN tbl_pagetitle on site_menu.PageTitleID = tbl_pagetitle.PageTitleID
						WHERE site_menu.site_id = :siteid;";

		$stmt = null;
		$stmt = $this->conn->prepare($query);
		$stmt->execute([':siteid' => $this->site_id]);
		$menu = array();
		if ($stmt->rowCount() > 0) {
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				extract($row);
				$m = new SiteMenu();
				$m->menu_id = $menu_id;
				$m->label = $label;
				$m->link = $link;

				if ($parent_menu_id > 0) {
					$menu[$parent_menu_id]->sub_menu[$menu_id] = $m;
				}
				else {
					$menu[$menu_id] = $m;
				}
			}
		}
		$site->menu = $menu;

		$query = "SELECT image_id, image_url FROM site_images WHERE site_id = :siteid;";
		$stmt = null;
		$stmt = $this->conn->prepare($query);
		$stmt->execute([':siteid' => $this->site_id]);
		$images = array();

		if ($stmt->rowCount() > 0) {
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				extract($row);
				$images[$image_id] = $image_url;
			}
		}
		$site->images = $images;

		//services
		$query = "SELECT tbl_siteservices.ServiceID, tbl_services.Services, OrderSort, Parent, TextType, tbl_servicetext.ServiceText
						FROM tbl_siteservices
							INNER JOIN tbl_services on tbl_siteservices.ServiceID = tbl_services.ServiceID
							INNER JOIN tbl_servicetext on tbl_siteservices.ServiceText = tbl_servicetext.ServiceTextID
							where tbl_siteservices.SiteID = :siteid and Parent is null;";
		$stmt = null;
		$stmt = $this->conn->prepare($query);
		$stmt->execute([':siteid' => $this->site_id]);
		$services = array();
		if ($stmt->rowCount() > 0) {
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$services = array_merge($services, $this->get_site_services($row));
			}
		}

		if (count($services) > 0) {
			$site_services = array();
			foreach ($services as $s) {
				$site_services[$s->service_id][] = $s;
			}
			$site->services = $site_services;
		}
		else {
			$site->services = array();
		}

		

		//service areas
		$query = "SELECT ServiceAreaID, ServiceAreas
						FROM tbl_site_serviceareas
							INNER JOIN tbl_serviceareas on tbl_site_serviceareas.ServiceAreaID = tbl_serviceareas.ServiceAreasID
							WHERE SiteID = :siteid";
		$stmt = null;
		$stmt = $this->conn->prepare($query);
		$stmt->execute([':siteid' => $this->site_id]);
		$service_areas = array();
		if ($stmt->rowCount() > 0) {
			while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				extract($row);
				array_push($service_areas, $ServiceAreas);
			}
		}
		$stmt = null;
		$site->service_areas = $service_areas;

		return $site;
	}

	function get_site_services($row) {
		$services = array();
		extract($row);
		$s = new SiteService();
		$s->service_id = $ServiceID;
		$s->service_name = $Services;
		$s->service_text_type = $TextType;
		$s->service_text = $ServiceText;
		array_push($services, $s); 

		if ($Parent != NULL) {
			$services = array_merge($services, $this->get_service_by_parent($Parent));
		}

		return $services;
	}

	function get_service_by_parent($parent_id) {
		$query = "SELECT tbl_siteservices.ServiceID, tbl_services.Services, OrderSort, Parent, TextType, tbl_servicetext.ServiceText
					FROM tbl_siteservices
						INNER JOIN tbl_services on tbl_siteservices.ServiceID = tbl_services.ServiceID
						INNER JOIN tbl_servicetext on tbl_siteservices.ServiceText = tbl_servicetext.ServiceTextID
						where tbl_siteservices.Parent = :parent;";

		$stmt1 = $this->conn->prepare($query);
		$stmt1->execute([':parent' => $parent_id]);

		$services = array();
		if ($stmt1->rowCount() > 0) {
			while ($row = $stmt1->fetch(PDO::FETCH_ASSOC)) {
				$services = array_merge($services, $this->get_site_services($row));
			}
		}
		$stmt1 = null;
		return $services;
	}
}

